#!/usr/bin/env python3.6
# -*- coding: utf-8 -*-
#
# sgRNA sensor documentation build configuration file, created by
# sphinx-quickstart on Wed Mar 29 13:12:09 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.

## General configuration

# If your documentation needs a minimal Sphinx version, state it here.
needs_sphinx = '1.5'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [ #
    'sphinx.ext.mathjax',
    'sphinx.ext.viewcode',
    'sphinxcontrib.programoutput',
    'exmemo.sphinx.notebook',
    'exmemo.sphinx.biology',
    'exmemo.sphinx.general',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['.templates']

# Ignore warnings about duplicate citations.
suppress_warnings = ['ref.citation']

# The suffix(es) of source filenames.
# You can specify multiple suffixes as a list of strings.
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = '{{ cookiecutter.project_title }}'
copyright = '{{ cookiecutter.year }}, {{ cookiecutter.full_name }}'
author = '{{ cookiecutter.full_name }}'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = ''
# The full version, including alpha/beta/rc tags.
release = ''

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = [ #
        'build',
        'Thumbs.db',
        '.DS_Store',
]

rst_epilog = ".. |br| raw:: html\n\n   <br />"

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

## Options for HTML output

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
from sphinx_rtd_theme import get_html_theme_path
html_theme = "sphinx_rtd_theme"
html_theme_path = [get_html_theme_path()]

# Specify the favicon.
from exmemo.sphinx import favicon_path
html_favicon = str(favicon_path)

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['.static']

## Options for HTMLHelp output

# Output file base name for HTML help builder.
htmlhelp_basename = '{{ cookiecutter.project_slug }}'

## Options for LaTeX output

latex_elements = { #
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [ #
    (master_doc, '{{ cookiecutter.project_slug }}.tex', '{{ cookiecutter.project_title }}',
     '{{ cookiecutter.full_name }}', 'manual'),
]

## Options for manual page output

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [ #
    (master_doc, '{{ cookiecutter.project_slug }}', '{{ cookiecutter.project_title }}',
     [author], 1)
]

## Options for Texinfo output

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [ #
    (master_doc, '{{ cookiecutter.project_slug }}', '{{ cookiecutter.project_title }}',
     author, '{{ cookiecutter.project_slug }}', 'One line description of project.',
     'Miscellaneous'),
]



